/*
 * Decompiled with CFR 0.152.
 */
package jtbcore.db.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jtbcore.db.model.TableModel;
import jtbcore.exception.InvalidStateException;
import jtbcore.model.ResourceLoader;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DatabaseModel {
    protected Map<String, TableModel> tables = new ConcurrentHashMap<String, TableModel>();
    protected String path;
    protected ResourceLoader resourceLoader;

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) throws IOException {
        this.path = path;
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void loadModel() throws ParserConfigurationException, SAXException, IOException, InvalidStateException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (InputStream is = this.resourceLoader.getResource(this.getPath());){
            if (is == null) {
                throw new InvalidStateException("Path to resource not found: " + this.getPath());
            }
            this.loadModel(is);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void loadModel(InputStream inp) throws ParserConfigurationException, SAXException, IOException, InvalidStateException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder b = dbf.newDocumentBuilder();
        Document doc = b.parse(inp);
        NodeList tables = doc.getElementsByTagName("table");
        int x = 0;
        while (x < tables.getLength()) {
            Node nTable = tables.item(x);
            TableModel tm = new TableModel();
            tm.loadNodes(nTable);
            if (this.tables.containsKey(tm.getName())) {
                System.err.println("Warning, overwriting table settings: " + tm.getName());
            }
            this.tables.put(tm.getName(), tm);
            ++x;
        }
    }

    public Map<String, TableModel> getTables() {
        return this.tables;
    }

    public TableModel getTable(String name) {
        return this.tables.get(name);
    }

    public void addTable(TableModel tm) {
        this.tables.put(tm.getName(), tm);
    }

    public static void main(String[] args) {
    }
}

